/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lhadecompressor;

import java.io.File;
import java.io.IOException;
import java.util.zip.Checksum;
import net.sourceforge.lhadecompressor.CRC16;
import net.sourceforge.lhadecompressor.LhaEntry;
import net.sourceforge.lhadecompressor.LhaException;
import net.sourceforge.lhadecompressor.Sum;

public abstract class LhaEntryReader {
    protected static final char HD_CHR_DELIM_MSDOS = '\\';
    protected static final char HD_CHR_DELIM_UNIX = '/';
    protected static final char HD_CHR_DELIM_MAC = ':';
    protected static final byte HD_CHR_DELIM_EXTRA = -1;
    protected static final int HDRU_SIZE = 21;
    protected static final int HDRU_OFF_HEADERSIZE = 0;
    protected static final int HDRU_OFF_LVL = 20;
    protected static final int HDR0_OFF_SUM = 1;
    protected static final int HDR0_OFF_METHOD = 2;
    protected static final int HDR0_OFF_COMPSIZE = 7;
    protected static final int HDR0_OFF_ORIGSIZE = 11;
    protected static final int HDR0_OFF_TIMESTAMP = 15;
    protected static final int HDR0_OFF_FILEATTR = 19;
    protected static final int HDR1_OFF_SUM = 1;
    protected static final int HDR1_OFF_METHOD = 2;
    protected static final int HDR1_OFF_SKIPSIZE = 7;
    protected static final int HDR1_OFF_ORIGSIZE = 11;
    protected static final int HDR1_OFF_TIMESTAMP = 15;
    protected static final int HDR1_OFF_19 = 19;
    protected static final int HDR2_OFF_METHOD = 2;
    protected static final int HDR2_OFF_COMPSIZE = 7;
    protected static final int HDR2_OFF_ORIGSIZE = 11;
    protected static final int HDR2_OFF_TIMESTAMP = 15;
    protected static final int HDR2_OFF_RESERVED = 19;
    protected static final byte HDR_SIG_LVL0 = 0;
    protected static final byte HDR_SIG_LVL1 = 1;
    protected static final byte HDR_SIG_LVL2 = 2;
    protected static final String HD_STR_METHOD_ENCODING = "US-ASCII";
    protected String encoding;
    protected int srcSum;
    protected int srcCRC;
    protected Checksum calcSum;
    protected Checksum calcCRC;
    protected boolean flagSum;
    protected boolean flagCRC;
    protected String fileName = "";
    protected String dirName = "";

    public LhaEntryReader(String encoding) {
        this.encoding = encoding;
        this.calcSum = new Sum();
        this.calcCRC = new CRC16();
    }

    protected LhaEntry readHeader() throws LhaException, IOException {
        LhaEntry e;
        byte[] base = new byte[21];
        this.calcSum.reset();
        this.calcCRC.reset();
        this.flagSum = false;
        this.flagCRC = false;
        this.fileName = "";
        this.dirName = "";
        int n = this._read(base);
        if (n <= 0 || n == 1 && base[0] == 0) {
            return null;
        }
        if (n != 21) {
            throw new LhaException("header is broken (header size does'nt match)");
        }
        switch (base[20]) {
            case 0: {
                e = this.readHeader_Lv0(base);
                break;
            }
            case 1: {
                e = this.readHeader_Lv1(base);
                break;
            }
            case 2: {
                e = this.readHeader_Lv2(base);
                break;
            }
            default: {
                throw new LhaException("Unsupported Lha header level: " + base[20]);
            }
        }
        return e;
    }

    protected LhaEntry readHeader_Lv0(byte[] base) throws LhaException, IOException {
        LhaEntry e = new LhaEntry();
        this.flagSum = true;
        byte headerSize = base[0];
        this.srcSum = base[1];
        if (this.srcSum < 0) {
            this.srcSum += 256;
        }
        e.setMethod(new String(base, 2, 5, HD_STR_METHOD_ENCODING));
        e.setCompressedSize(LhaEntryReader.get32(base, 7));
        e.setOriginalSize(LhaEntryReader.get32(base, 11));
        e.setDosTimeStamp(LhaEntryReader.get32(base, 15));
        this.calcSum.update(base, 2, base.length - 2);
        byte[] buf = new byte[1];
        if (this._read(buf) != buf.length) {
            throw new LhaException("Lha header is broken (header size does'nt match)");
        }
        byte nameSize = buf[0];
        this.calcSum.update(buf, 0, buf.length);
        buf = new byte[nameSize];
        if (this._read(buf) != buf.length) {
            throw new LhaException("Lha header is broken (cannot read name)");
        }
        String name = new String(buf, this.encoding);
        this.calcSum.update(buf, 0, buf.length);
        int diff = headerSize - nameSize;
        if (diff != 20 && diff != 22 && diff < 23) {
            throw new LhaException("Lha header is broken (header size does'nt match)");
        }
        e.setOS((byte)0);
        if (diff >= 22) {
            buf = new byte[2];
            if (this._read(buf) != buf.length) {
                throw new LhaException("Lha header is broken (cannot read crc value)");
            }
            e.setCRC(LhaEntryReader.get16(buf, 0));
            this.calcSum.update(buf, 0, buf.length);
        }
        if (diff >= 23) {
            buf = new byte[1];
            if (this._read(buf) != buf.length) {
                throw new LhaException("Lha header is broken (cannot read os signature)");
            }
            e.setOS(buf[0]);
            this.calcSum.update(buf, 0, buf.length);
        }
        if (diff > 23) {
            buf = new byte[diff - 24];
            if (this._read(buf) != buf.length) {
                throw new LhaException("Lha header is broken (cannot read ext)");
            }
            this.calcSum.update(buf, 0, buf.length);
        }
        e.setFile(this.convertFilePath(name, e.getOS()));
        return e;
    }

    protected LhaEntry readHeader_Lv1(byte[] base) throws LhaException, IOException {
        LhaEntry e = new LhaEntry();
        this.flagSum = true;
        this.srcSum = base[1];
        if (this.srcSum < 0) {
            this.srcSum += 256;
        }
        e.setMethod(new String(base, 2, 5, HD_STR_METHOD_ENCODING));
        e.setOriginalSize(LhaEntryReader.get32(base, 11));
        e.setDosTimeStamp(LhaEntryReader.get32(base, 15));
        if (base[19] != 32) {
            throw new LhaException("Lha header is broken (offset 19 is not 0x20)");
        }
        this.calcSum.update(base, 2, base.length - 2);
        this.calcCRC.update(base, 0, base.length);
        byte[] buf = new byte[1];
        if (this._read(buf) != buf.length) {
            throw new LhaException("Lha header is broken (cannot read name size)");
        }
        byte nameSize = buf[0];
        this.calcSum.update(buf, 0, buf.length);
        this.calcCRC.update(buf, 0, buf.length);
        String name = "";
        if (nameSize > 0) {
            buf = new byte[nameSize];
            if (this._read(buf) != buf.length) {
                throw new LhaException("Lha header is broken (cannot read name)");
            }
            name = new String(buf, this.encoding);
            this.calcSum.update(buf, 0, buf.length);
            this.calcCRC.update(buf, 0, buf.length);
        }
        if (this._read(buf = new byte[2]) != buf.length) {
            throw new LhaException("Lha header is broken (cannot read crc value)");
        }
        e.setCRC(LhaEntryReader.get16(buf, 0));
        this.calcSum.update(buf, 0, buf.length);
        this.calcCRC.update(buf, 0, buf.length);
        buf = new byte[1];
        if (this._read(buf) != buf.length) {
            throw new LhaException("Lha header is broken (cannot read os signature)");
        }
        e.setOS(buf[0]);
        this.calcSum.update(buf, 0, buf.length);
        this.calcCRC.update(buf, 0, buf.length);
        long extSize = 0L;
        buf = new byte[2];
        if (this._read(buf) != buf.length) {
            throw new LhaException("Lha header is broken (cannot read ext)");
        }
        this.calcSum.update(buf, 0, buf.length);
        this.calcCRC.update(buf, 0, buf.length);
        int next = LhaEntryReader.get16(buf, 0);
        while (next > 0) {
            extSize += (long)next;
            next = this.readExHeader(e, next);
        }
        e.setCompressedSize(LhaEntryReader.get32(base, 7) - extSize);
        name = this.fileName.length() > 0 ? this.dirName + this.fileName : this.convertFilePath(name, e.getOS());
        e.setFile(name);
        return e;
    }

    protected LhaEntry readHeader_Lv2(byte[] base) throws LhaException, IOException {
        LhaEntry e = new LhaEntry();
        e.setMethod(new String(base, 2, 5, HD_STR_METHOD_ENCODING));
        e.setCompressedSize(LhaEntryReader.get32(base, 7));
        e.setOriginalSize(LhaEntryReader.get32(base, 11));
        e.setHeaderTimeStamp(LhaEntryReader.get32(base, 15));
        this.calcCRC.update(base, 0, base.length);
        byte[] buf = new byte[2];
        if (this._read(buf) != buf.length) {
            throw new LhaException("Lha header is broken (cannot read crc value)");
        }
        e.setCRC(LhaEntryReader.get16(buf, 0));
        this.calcCRC.update(buf, 0, buf.length);
        buf = new byte[1];
        if (this._read(buf) != buf.length) {
            throw new LhaException("Lha header is broken (cannot read os signature)");
        }
        e.setOS(buf[0]);
        this.calcCRC.update(buf, 0, buf.length);
        buf = new byte[2];
        if (this._read(buf) != buf.length) {
            throw new LhaException("Lha header is broken (cannot read ext)");
        }
        this.calcCRC.update(buf, 0, buf.length);
        int next = LhaEntryReader.get16(buf, 0);
        while (next > 0) {
            next = this.readExHeader(e, next);
        }
        e.setFile(this.dirName + this.fileName);
        return e;
    }

    protected int readExHeader(LhaEntry e, int size) throws LhaException, IOException {
        byte[] buf = new byte[size];
        if (this._read(buf) != buf.length) {
            throw new LhaException("header is broken");
        }
        switch (buf[0]) {
            case 0: {
                this.flagCRC = true;
                this.srcCRC = LhaEntryReader.get16(buf, 1);
                buf[1] = 0;
                buf[2] = 0;
                break;
            }
            case 1: {
                this.fileName = new String(buf, 1, size - 3, this.encoding);
                break;
            }
            case 2: {
                StringBuffer dname = new StringBuffer();
                int pi = 0;
                for (int i = 1; i <= size - 3; ++i) {
                    if (buf[i] != -1) continue;
                    dname.append(new String(buf, pi + 1, i - pi - 1, this.encoding));
                    dname.append(File.separator);
                    pi = i;
                }
                dname.append(new String(buf, pi + 1, size - 3 - pi, this.encoding));
                this.dirName = dname.toString();
                break;
            }
            case 63: {
                break;
            }
            case 64: {
                break;
            }
            case 65: {
                break;
            }
            case 80: {
                break;
            }
            case 81: {
                break;
            }
            case 82: {
                break;
            }
            case 83: {
                break;
            }
            case 84: {
                break;
            }
        }
        this.calcCRC.update(buf, 0, buf.length);
        return LhaEntryReader.get16(buf, size - 2);
    }

    protected String convertFilePath(String s, byte os) {
        char delim;
        switch (os) {
            case 0: 
            case 77: 
            case 87: 
            case 119: {
                delim = '\\';
                break;
            }
            case 109: {
                delim = ':';
                break;
            }
            default: {
                delim = '/';
            }
        }
        char[] c = s.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == delim) {
                c[i] = File.separatorChar;
                continue;
            }
            if (c[i] != File.separatorChar) continue;
            c[i] = delim;
        }
        return new String(c);
    }

    protected abstract int _read(byte[] var1) throws IOException;

    private static final int get16(byte[] b, int off) {
        return b[off] & 0xFF | (b[off + 1] & 0xFF) << 8;
    }

    private static final long get32(byte[] b, int off) {
        return (long)LhaEntryReader.get16(b, off) | (long)LhaEntryReader.get16(b, off + 2) << 16;
    }
}

